<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Template extends MX_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->db->query('SET SESSION sql_mode = ""');
		$this->load->model(array(
			'template_model'
		));
        $this->load->library('form_validation');
	}
 
	public function layout($data)
	{  
		$id = $this->session->userdata('id');
		$data['notifications'] = $this->template_model->notifications($id);
		$data['quick_messages'] = $this->template_model->messages($id);
		$data['setting'] = $this->template_model->setting();
		$this->load->view('layout', $data);
	}

	public function login($data)
	{ 
		$data['setting'] = $this->template_model->setting();
		$this->load->view('login', $data);
	}

	public function register_view($data) {
		$data['designation']  = $this->template_model->designation();
		$data['dropdowndept'] 	= $this->template_model->dropdowndept();
        $this->load->view('register_view', $data);
		
    }

    public function registration_success_view($data) {
        $this->load->view('registration_success_view', $data);
    }
    
	public function register_verify($data) {
    	 $data['designation']  = $this->template_model->designation();
        $this->load->view('register_verify', $data);
    }


	public function resend_activation($data) {
        $this->load->view('resend_activation', $data);
    }

	public function request($data) {
        $this->load->view('request', $data);
    }

	public function reset($data) {
        $this->load->view('reset', $data);
    }
    
    public function fetch_divisions() {
    $directorate_id = $this->input->post('directorate_id');

    if ($directorate_id) {
        $divisions = $this->db->select('*')->from('department')->where('parent_id', $directorate_id)->get()->result();

        if ($divisions) {
            foreach ($divisions as $division) {
                echo '<option value="'.$division->dept_id.'">'.$division->department_name.'</option>';
            }
        } else {
            echo '<option value="">No divisions available</option>';
        }
    } else {
        echo '<option value="">Select Division</option>';
    }
}


}	