<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Registration</title>
    <link href="<?php echo base_url(); ?>assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="<?php echo base_url(); ?>assets/css/custom.css" rel="stylesheet" type="text/css" />
</head>


<body>
    <div class="login-wrapper">
        <div class="container-center" style="max-width:600px">
            <div class="panel panel-bd">
                <div class="panel-heading">
                    <div class="view-header">
                        <div class="header-icon">
                            <i class="pe-7s-add-user"></i>
                        </div>
                        <div class="header-title">
                            <h3 style="text-align:center">Registration</h3>
                        </div>
                    </div>
                    <div class="row">
                        <?php if ($this->session->flashdata('exception')) { ?>
                        <div class="alert alert-danger alert-dismissable">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <?php echo $this->session->flashdata('exception'); ?>
                        </div>
                        <?php } ?>
                    </div>
                </div>

                <div class="panel-body">
                    <?php
                    if ($this->session->flashdata('validation_errors')) {
                        echo '<div class="alert alert-danger alert-dismissable">';
                        echo '  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>';
                        echo $this->session->flashdata('validation_errors');
                        echo '</div>';
                    }
                    ?>
                    <?php echo form_open_multipart('register/submit', 'id="registrationForm" novalidate'); ?>

                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="text" placeholder="Email" name="email" id="email" class="form-control" value="<?= set_value('email'); ?>">
                    </div>

                    <div class="form-group">
                        <label for="first_name">First Name</label>
                        <input type="text" placeholder="First Name" name="first_name" id="first_name" class="form-control" value="<?= set_value('first_name'); ?>">
                    </div>

                    <div class="form-group">
                        <label for="last_name">Last Name</label>
                        <input type="text" placeholder="Last Name" name="last_name" id="last_name" class="form-control" value="<?= set_value('last_name'); ?>">
                    </div>

                    <div class="form-group">
                        <label for="gender">Gender</label>
                        <select name="gender" id="gender" class="form-control">
                            <option value="" disabled>Select an option</option>
                            <option value="1" <?= set_select('gender', '1'); ?>>Male</option>
                            <option value="2" <?= set_select('gender', '2'); ?>>Female</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="designation">Job Title</label>
                        <select name="designation" id="designation" class="form-control">
                            <option value="">Select Designation</option>
                            <?php foreach ($designation as $desig) { ?>
                            <option value="<?= $desig->pos_id ?>" <?= set_select('designation', $desig->pos_id); ?>><?= $desig->position_name ?></option>
                            <?php } ?>
                        </select>
                        <span id="desig"></span>
                    </div>

                    <div class="form-group">
                        <label for="present_salary_category">Present Salary Category</label>
                        <input type="text" placeholder="Present Salary Category" name="present_salary_category" id="present_salary_category" class="form-control" value="<?= set_value('present_salary_category'); ?>">
                    </div>

                    <div class="form-group">
                        <label for="date_of_employment">Date Of Employment</label>
                        <input type="date" name="date_of_employment" id="date_of_employment" class="form-control" value="<?= set_value('date_of_employment'); ?>">
                    </div>

                    <div class="form-group">
                        <label for="date_of_last_promotion">Date and Grade of Last Promotion</label>
                        <input type="text" placeholder="Date and Grade of Last Promotion" name="date_of_last_promotion" id="date_of_last_promotion" class="form-control" value="<?= set_value('date_of_last_promotion'); ?>">
                    </div>

                    <div class="form-group">
                        <label for="directorate">Directorate</label>
                        <select name="directorate" id="directorate" class="form-control">
                            <option value="">Select Directorate</option>
                            <?php foreach ($dropdowndept as $division) { ?>
                            <option value="<?= $division['dept_id'] ?>" <?= set_select('directorate', $division['dept_id']); ?>><?= $division['department_name'] ?></option>
                            <?php } ?>
                        </select>
                        <span id="direct"></span>
                    </div>

                    <div class="form-group">
                        <label for="division">Department</label>
                        <select name="division" id="division" class="form-control">
                            <option value="">Select Department</option>
                        </select>
                        <span id="divis"></span>
                    </div>

                    <div class="form-group">
                        <label for="appointment_confirmed">Has Your Appointment Been Confirmed?</label>
                        <select name="appointment_confirmed" id="appointment_confirmed" class="form-control">
                            <option value="" disabled>Select an option</option>
                            <option value="yes" <?= set_select('appointment_confirmed', 'yes'); ?>>Yes</option>
                            <option value="no" <?= set_select('appointment_confirmed', 'no'); ?>>No</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="qualification">Qualifications</label>
                        <input type="text" placeholder="Qualification" name="qualification" id="qualification" class="form-control" value="<?= set_value('qualification'); ?>">
                    </div>

                    <h4>Academic Qualifications</h4>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Name of Institution</th>
                                    <th>Duration (From)</th>
                                    <th>Duration (To)</th>
                                    <th>Qualification(s) Obtained</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php for($i = 0; $i < 4; $i++): ?>
                                <tr>
                                    <td><textarea name="academic_institution[]" class="form-control"><?= set_value("academic_institution[$i]"); ?></textarea></td>
                                    <td><input type="month" name="academic_duration_from[]" class="form-control" value="<?= set_value("academic_duration_from[$i]"); ?>"></td>
                                    <td><input type="month" name="academic_duration_to[]" class="form-control" value="<?= set_value("academic_duration_to[$i]"); ?>"></td>
                                    <td><textarea name="academic_qualification[]" class="form-control"><?= set_value("academic_qualification[$i]"); ?></textarea></td>
                                </tr>
                                <?php endfor; ?>
                            </tbody>
                        </table>
                    </div>

                    <h4>Professional Qualifications</h4>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Qualifications</th>
                                    <th>Awarding Body/Society</th>
                                    <th>Date of Award</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php for($i = 0; $i < 4; $i++): ?>
                                <tr>
                                    <td><textarea name="professional_qualification[]" class="form-control"><?= set_value("professional_qualification[$i]"); ?></textarea></td>
                                    <td><textarea name="professional_awarding_body[]" class="form-control"><?= set_value("professional_awarding_body[$i]"); ?></textarea></td>
                                    <td><input type="month" name="professional_date_of_award[]" class="form-control" value="<?= set_value("professional_date_of_award[$i]"); ?>"></td>
                                </tr>
                                <?php endfor; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" placeholder="Password" name="password" id="password" class="form-control">
                    </div>

                    <div class="form-group">
                        <label for="confirm_password">Confirm Password</label>
                        <input type="password" placeholder="Confirm Password" name="confirm_password" id="confirm_password" class="form-control">
                    </div>

                    <div>
                        <button type="reset" class="btn btn-info">Reset</button>
                        <button type="submit" class="btn btn-success">Register</button>
                    </div>

                    <?php echo form_close(); ?>
                    <div style="margin-top:10px">
                        <p>Already have an account? <a href="<?php echo site_url('login'); ?>">Login</a>.</p>
                        <p>Token Expired? <a href="<?php echo site_url('register/resend'); ?>">Resend Token</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="<?php echo base_url('assets/js/jquery-3.6.0.min.js') ?>" type="text/javascript"></script>
    <script>
      $(document).ready(function() {
          // Load data from localStorage if available
          $('input, select, textarea').each(function() {
              const input = $(this);
              const savedValue = localStorage.getItem(input.attr('name'));
              if (savedValue) {
                  input.val(savedValue);
              }
          });

          // Save data to localStorage on input change
          $('input, select, textarea').on('input change', function() {
              localStorage.setItem($(this).attr('name'), $(this).val());
          });

          // Clear localStorage on successful form submission
          $('#registrationForm').on('submit', function() {
              localStorage.clear();
          });

          // Handle dynamic divisions based on directorate
          $('#directorate').change(function() {
              var directorateID = $(this).val();
              if (directorateID) {
                  $.ajax({
                      type: 'POST',
                      url: '<?= base_url("template/fetch_divisions"); ?>',
                      data: 'directorate_id=' + directorateID,
                      success: function(html) {
                          $('#division').html(html);
                      }
                  });
              } else {
                  $('#division').html('<option value="">Select Department</option>');
              }
          });
      });
    </script>
</body>

</html>